/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io;

import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.statet.ecommons.io.FileValidator;
import org.eclipse.statet.ecommons.variables.core.ObservableVariable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ObservableFileValidator
extends FileValidator {
    private final Realm realm;
    private @Nullable IChangeListener observableListener;
    private @Nullable ResourceObservableValue resourceObservable;
    private @Nullable FileStoreObservableValue fileStoreObservable;

    public ObservableFileValidator(Realm realm) {
        this.realm = realm;
    }

    @Override
    void checkVariable(IStringVariable variable) {
        if (variable instanceof ObservableVariable) {
            IChangeListener listener = this.observableListener;
            if (listener == null) {
                this.observableListener = listener = new IChangeListener(){

                    public void handleChange(ChangeEvent event) {
                        ObservableFileValidator.this.updateVariableResolution();
                    }
                };
            }
            ((ObservableVariable)variable).addChangeListener(listener);
        }
    }

    @Override
    protected void setStatus(@Nullable IStatus status) {
        super.setStatus(status);
        AbstractObservableValue observable = this.resourceObservable;
        if (observable != null) {
            observable.update(this.getWorkspaceResource());
        }
        if ((observable = this.fileStoreObservable) != null) {
            observable.update(this.getFileStore());
        }
    }

    public IObservableValue<@Nullable IResource> getWorkspaceResourceObservable() {
        ResourceObservableValue observable = this.resourceObservable;
        if (observable == null) {
            observable = new ResourceObservableValue(this.realm);
            observable.update(this.getWorkspaceResource());
            this.resourceObservable = observable;
        }
        return observable;
    }

    public IObservableValue<@Nullable IFileStore> getFileStoreObservable() {
        FileStoreObservableValue observable = this.fileStoreObservable;
        if (observable == null) {
            observable = new FileStoreObservableValue(this.realm);
            observable.update(this.getFileStore());
            this.fileStoreObservable = observable;
        }
        return observable;
    }

    private class FileStoreObservableValue
    extends AbstractObservableValue<IFileStore> {
        private @Nullable IFileStore value;

        public FileStoreObservableValue(Realm realm) {
            super(realm);
        }

        public Object getValueType() {
            return IFileStore.class;
        }

        protected @Nullable IFileStore doGetValue() {
            return this.value;
        }

        protected void doSetValue(@Nullable IFileStore value) {
            ObservableFileValidator.this.setExplicit(value);
            ObservableFileValidator.this.checkExplicit();
        }

        void update(@Nullable IFileStore newValue) {
            if (newValue != null ? !newValue.equals(this.value) : this.value != null) {
                this.value = newValue;
                this.fireValueChange(Diffs.createValueDiff((Object)this.value, (Object)this.value));
            }
        }
    }

    private class ResourceObservableValue
    extends AbstractObservableValue<IResource> {
        private @Nullable IResource value;

        public ResourceObservableValue(Realm realm) {
            super(realm);
        }

        public Object getValueType() {
            return IResource.class;
        }

        protected @Nullable IResource doGetValue() {
            return this.value;
        }

        protected void doSetValue(@Nullable IResource value) {
            ObservableFileValidator.this.setExplicit(value);
            ObservableFileValidator.this.checkExplicit();
        }

        void update(@Nullable IResource newValue) {
            if (newValue != null ? !newValue.equals((Object)this.value) : this.value != null) {
                this.value = newValue;
                this.fireValueChange(Diffs.createValueDiff((Object)this.value, (Object)this.value));
            }
        }
    }
}

