/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.io.win;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.io.win.DDE;
import org.eclipse.statet.internal.ecommons.coreutils.CoreMiscellanyPlugin;

public class DDEClient {
    public static final int INIT_FAILED = 1;
    public static final int CONNECT_FAILED = 2;

    static {
        try {
            System.loadLibrary("ddeclient");
        }
        catch (UnsatisfiedLinkError e) {
            if (DDE.isSupported()) {
                CoreMiscellanyPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", "The DDEclient library could not be loaded.", (Throwable)e));
            }
            DDE.gIsAvailable = false;
        }
    }

    public static void execute(String server, String topic, String command) throws CoreException {
        if (server == null) {
            throw new NullPointerException("server");
        }
        if (topic == null) {
            throw new NullPointerException("topic");
        }
        if (command == null) {
            throw new NullPointerException("command");
        }
        int error = DDE.isSupported() ? DDEClient.ddeExecute(server, topic, command) : 1001;
        if (error != 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.ecommons.coremisc", error, "Executing DDE command failed:\n\tserver= " + server + "\n\ttopic= " + topic + "\n\tcommand= " + command, null));
        }
    }

    private static native int ddeExecute(String var0, String var1, String var2);
}

