/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.NullDefaultLocation;

@NonNullByDefault
public class ChainedValidator<T>
implements IValidator<T> {
    private final ImList<IValidator<? super T>> validators;

    public ChainedValidator(ImList<IValidator<? super T>> validators) {
        this.validators = validators;
    }

    @NonNullByDefault(value={NullDefaultLocation.RETURN_TYPE})
    public IStatus validate(T value) {
        @NonNull IStatus status = ValidationStatus.ok();
        for (IValidator validator : this.validators) {
            IStatus current = validator.validate(value);
            if (current.getSeverity() > status.getSeverity() && (status = current).getSeverity() >= 4) break;
        }
        return status;
    }
}

