/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.bind.unmarshaller_1;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.dom.DOMSource;
import org.xml.sax.InputSource;
import org.w3c.dom.Document;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class UnmarshalCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        UnmarshalCTTests test = new UnmarshalCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status Unmarshal001( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             obj = um.unmarshal(new File(doc_path));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal002( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             obj = um.unmarshal(new File(doc_path));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal003( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-bad.xml"));
         try {
             obj = um.unmarshal(new File(doc_path));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }

    public Status Unmarshal004( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             obj = um.unmarshal(new FileInputStream(doc_path));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (java.io.FileNotFoundException fne){
             return Status.failed("FileNotFoundException: unmarshal-1.xml");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal005( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             obj = um.unmarshal(new FileInputStream(doc_path));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (java.io.FileNotFoundException fne){
             return Status.failed("FileNotFoundException: unmarshal-1.xml");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal006( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-bad.xml"));
         try {
             obj = um.unmarshal(new FileInputStream(doc_path));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         } catch (java.io.FileNotFoundException fne){
             return Status.failed("FileNotFoundException: unmarshal-bad.xml");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }

    public Status Unmarshal007( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             obj = um.unmarshal(getDocumentURL("unmarshal-1.xml"));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal008( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         try {
             obj = um.unmarshal(getDocumentURL("unmarshal-1.xml"));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal009( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         try {
             obj = um.unmarshal(getDocumentURL("unmarshal-bad.xml"));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }

    public Status Unmarshal010( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             obj = um.unmarshal(new org.xml.sax.InputSource(new java.io.FileInputStream(doc_path)));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (java.io.FileNotFoundException fne){
             return Status.failed("FileNotFoundException: unmarshal-1.xml");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal011( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             obj = um.unmarshal(new org.xml.sax.InputSource(new java.io.FileInputStream(doc_path)));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (java.io.FileNotFoundException fne){
             return Status.failed("FileNotFoundException: unmarshal-1.xml");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal012( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-bad.xml"));
         try {
             obj = um.unmarshal(new org.xml.sax.InputSource(new java.io.FileInputStream(doc_path)));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         } catch (java.io.FileNotFoundException fne){
             return Status.failed("FileNotFoundException: unmarshal-1.xml");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }

    public Status Unmarshal013( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
             dbf.setNamespaceAware(true);
             DocumentBuilder db = dbf.newDocumentBuilder();
             Document doc = db.parse(new File(doc_path));
             obj = um.unmarshal(doc);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (javax.xml.parsers.ParserConfigurationException pe){
             return Status.failed("unexpected ParserConfigurationException");
         } catch (org.xml.sax.SAXException se){
             return Status.failed("unexpected SAXException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal014( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
             dbf.setNamespaceAware(true);
             DocumentBuilder db = dbf.newDocumentBuilder();
             Document doc = db.parse(new File(doc_path));
             obj = um.unmarshal(doc);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (javax.xml.parsers.ParserConfigurationException pe){
             return Status.failed("unexpected ParserConfigurationException");
         } catch (org.xml.sax.SAXException se){
             return Status.failed("unexpected SAXException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal015( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-bad.xml"));
         try {
             DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
             dbf.setNamespaceAware(true);
             DocumentBuilder db = dbf.newDocumentBuilder();
             Document doc = db.parse(new File(doc_path));
             obj = um.unmarshal(doc);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         } catch (javax.xml.parsers.ParserConfigurationException pe){
             return Status.failed("unexpected ParserConfigurationException");
         } catch (org.xml.sax.SAXException se){
             return Status.failed("unexpected SAXException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }

    public Status Unmarshal016( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             SAXSource src = new SAXSource(new org.xml.sax.InputSource(new java.io.FileInputStream(doc_path)));
             obj = um.unmarshal(src);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal017( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             SAXSource src = new SAXSource(new org.xml.sax.InputSource(new java.io.FileInputStream(doc_path)));
             obj = um.unmarshal(src);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal018( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-bad.xml"));
         try {
             SAXSource src = new SAXSource(new org.xml.sax.InputSource(new java.io.FileInputStream(doc_path)));
             obj = um.unmarshal(src);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }

    public Status Unmarshal019( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             StreamSource src = new StreamSource(new File(doc_path));
             obj = um.unmarshal(src);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal020( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             StreamSource src = new StreamSource(new File(doc_path));
             obj = um.unmarshal(src);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal021( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-bad.xml"));
         try {
             StreamSource src = new StreamSource(new File(doc_path));
             obj = um.unmarshal(src);
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }

    public Status Unmarshal022( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
             dbf.setNamespaceAware(true);
             DocumentBuilder db = dbf.newDocumentBuilder();
             Document doc = db.parse(new File(doc_path));
             obj = um.unmarshal(new DOMSource(doc));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (javax.xml.parsers.ParserConfigurationException pe){
             return Status.failed("unexpected ParserConfigurationException");
         } catch (org.xml.sax.SAXException se){
             return Status.failed("unexpected SAXException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal023( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-1.xml"));
         try {
             DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
             dbf.setNamespaceAware(true);
             DocumentBuilder db = dbf.newDocumentBuilder();
             Document doc = db.parse(new File(doc_path));
             obj = um.unmarshal(new DOMSource(doc));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-1.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-1.xml\") unexpectedly throws JAXBException");
         } catch (javax.xml.parsers.ParserConfigurationException pe){
             return Status.failed("unexpected ParserConfigurationException");
         } catch (org.xml.sax.SAXException se){
             return Status.failed("unexpected SAXException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         if (((JAXBElement<Long>)obj).getValue().longValue() != 717){
             return Status.failed("unmarshalled object: getValue() returns " + ((JAXBElement<Long>)obj).getValue() + " instead of 717");
         }
         return Status.passed("OK");
    }

    public Status Unmarshal024( ) {
        JAXBContext jc = null;
         Object obj = null;
         Unmarshaller um = null;
         try {
             jc = getJAXBContext();
             um = jc.createUnmarshaller();
         } catch (JAXBException je){
             return Status.failed("Unable to create valid context or unmarshaller");
         }
         try {
             um.setEventHandler(new MyValidationEventHandler(true));
         } catch (JAXBException je){
             return Status.failed("setEventHandler() throws JAXBException");
         }
         um.setSchema(schema);
         String doc_path = getDocumentPath(getDocumentURL("unmarshal-bad.xml"));
         try {
             DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
             dbf.setNamespaceAware(true);
             DocumentBuilder db = dbf.newDocumentBuilder();
             Document doc = db.parse(new File(doc_path));
             obj = um.unmarshal(new DOMSource(doc));
             if (obj == null){
                 return Status.failed("unmarshal(\"unmarshal-bad.xml\") returns null");
             }
         } catch (JAXBException je){
             return Status.failed("unmarshal(\"unmarshal-bad.xml\") unexpectedly throws JAXBException");
         } catch (javax.xml.parsers.ParserConfigurationException pe){
             return Status.failed("unexpected ParserConfigurationException");
         } catch (org.xml.sax.SAXException se){
             return Status.failed("unexpected SAXException");
         } catch (java.io.IOException ioe){
             return Status.failed("unexpected IOException");
         }
         ((JAXBElement<Long>)obj).setValue(new Long(1));
         return Status.passed("OK");
    }


}

