/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.anyuri.pattern.pattern_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import jakarta.xml.bind.JAXBException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class pattern1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        pattern1_ValidateCTTests test = new pattern1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final String[] validValues = {
        "ftp://ftp.guidelinesdu.com",
        "ftp://ftp.theinstandar.com",
        "ftp://ftp.intherelated.com",
        "ftp://ftp.forenvironme.com",
        "ftp://ftp.buildroleand.com"
    };
    
    final String[] invalidValues = {
        "", 
        "ftp://ftp.guidelinesd1.com",
        "ftp://ftp.theinstandar.edu",
        "http://ftp.theinstandar.com",
    };
    
    JAXBElement<String> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Unmarshalled001( ) {
        elemObj = (JAXBElement<String>)unmarshal("pattern-1-4.xml");
        return testValid();
    }

    public Status Unmarshalled002( ) {
        elemObj = (JAXBElement<String>)unmarshal("pattern-1-4.xml");
        return testInvalid();
    }

    public Status Created001( ) {
        elemObj = (JAXBElement<String>)(new ObjectFactory()).createNISTSchemaAnyURIPattern1(validValues[0]);
        
        return testValid();
    }

    public Status Created002( ) {
        elemObj = (JAXBElement<String>)(new ObjectFactory()).createNISTSchemaAnyURIPattern1(validValues[0]);
        
        return testInvalid();
    }


}

