/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.nonpositiveinteger.maxexclusive.maxexclusive_5;

import jakarta.xml.bind.*;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxExclusive5_GetSetCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxExclusive5_GetSetCTTests test = new maxExclusive5_GetSetCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status GetSet001( ) {
        String[] xmlDocNames = {
            "maxExclusive-5-1.xml", "maxExclusive-5-2.xml", "maxExclusive-5-3.xml",
            "maxExclusive-5-4.xml", "maxExclusive-5-5.xml"
        };
        BigInteger[] expectedValues = {new BigInteger("-99999999999999999999"), new BigInteger("-82542908187619623561"), 
                                       new BigInteger("-4545387295768354986"), new BigInteger("-2049358255056310531"), 
                                       new BigInteger("-1")};
        BigInteger[] anExpectedValues = {new BigInteger("-99999999999999999998"), new BigInteger("-11466563564055742842"), 
                                         new BigInteger("-83552316009832472421"), new BigInteger("-912086883376710844"), 
                                         new BigInteger("-1")};
        
        for (int i = 0; i < xmlDocNames.length; ++i){
            JAXBElement<BigInteger> elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocNames[i]);
            if (!elemObj.getValue().equals(expectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.getValue() != " + expectedValues[i]);
            }
            elemObj.setValue(anExpectedValues[i]);
            if (!elemObj.getValue().equals(anExpectedValues[i])){
                return Status.failed("used XML document: " + xmlDocNames[i] + ", elemObj.setValue(" + anExpectedValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anExpectedValues[i]);
            }
        }
        return Status.passed("OKAY");
    }

    public Status GetSet002( ) {
        BigInteger[] setValues = {new BigInteger("-99999999999999999999"), new BigInteger("-82542908187619623561"), 
                                       new BigInteger("-4545387295768354986"), new BigInteger("-2049358255056310531"), 
                                       new BigInteger("-1")};
        BigInteger[] anSetValues = {new BigInteger("-99999999999999999998"), new BigInteger("-11466563564055742842"), 
                                         new BigInteger("-83552316009832472421"), new BigInteger("-912086883376710844"), 
                                         new BigInteger("-1")};

        JAXBElement<BigInteger> elemObj = null;
        for (int i = 0; i < setValues.length; ++i){
            
                elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMaxExclusive5(setValues[i]);
            
            if (!elemObj.getValue().equals(setValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.getValue() != " + setValues[i]);
            }
            elemObj.setValue(anSetValues[i]);
            if (!elemObj.getValue().equals(anSetValues[i])){
                return Status.failed("dynamically created JAXBElement<BigInteger>, elemObj.setValue(" + anSetValues[i] + 
                    ") invoked, " + "elemObj.getValue() != " + anSetValues[i]);
            }
        }
        return Status.passed("OKAY");
    }


}

