/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.nonpositiveinteger.mininclusive.mininclusive_5;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minInclusive5_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minInclusive5_ValidateCTTests test = new minInclusive5_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final Integer[] validValues = {new Integer("0")};
    final Integer[] invalidValues = {new Integer("-1"), new Integer("1"), new Integer(Integer.MIN_VALUE), 
                                        new Integer(Integer.MAX_VALUE)};
    
    JAXBElement<Integer> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "minInclusive-5-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "minInclusive-5-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMinInclusive5(new Integer("0"));
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerMinInclusive5(new Integer("0"));
        
        return testInvalid();
    }


}

