/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.client.clientbuilder;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 7395392827433641768L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void newClientNoParamTest() throws JAXRSCommonClient.Fault {
        Client client = ClientBuilder.newClient();
        Assertions.assertTrue((client != null ? 1 : 0) != 0, (String)"could not create Client instance");
    }

    @Test
    public void newClientWithConfigurationTest() throws JAXRSCommonClient.Fault {
        String property = "JAXRSTCK";
        Client client = ClientBuilder.newClient();
        client.property(property, (Object)property);
        Configuration config = client.getConfiguration();
        client = ClientBuilder.newClient((Configuration)config);
        JAXRSClientIT.assertNotNull(client, "could not create Client instance");
        JAXRSClientIT.assertEquals(property, client.getConfiguration().getProperty(property), "client does not contain given config");
    }
}

