/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.bindingpriority;

import ee.jakarta.tck.ws.rs.api.rs.bindingpriority.HigherPriorityProvider;
import ee.jakarta.tck.ws.rs.api.rs.bindingpriority.LowerPriorityProvider;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 1501029701397272718L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void checkBindingPriorityHigherRegisteredFirstTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = new AtomicInteger(0);
        LowerPriorityProvider lowerProiority = new LowerPriorityProvider(ai);
        HigherPriorityProvider higherPriority = new HigherPriorityProvider(ai);
        Response response = this.invokeWithClientRequestFilters(higherPriority, lowerProiority);
        Assertions.assertTrue((response.getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)("returned status " + response.getStatus()));
    }

    @Test
    public void checkBindingPriorityLowerRegisteredFirstTest() throws JAXRSCommonClient.Fault {
        AtomicInteger ai = new AtomicInteger(0);
        LowerPriorityProvider lowerProiority = new LowerPriorityProvider(ai);
        HigherPriorityProvider higherPriority = new HigherPriorityProvider(ai);
        Response response = this.invokeWithClientRequestFilters(lowerProiority, higherPriority);
        Assertions.assertTrue((response.getStatus() == Response.Status.OK.getStatusCode() ? 1 : 0) != 0, (String)("returned status " + response.getStatus()));
    }

    protected Response invokeWithClientRequestFilters(ClientRequestFilter ... filters) {
        Client client = ClientBuilder.newClient();
        for (ClientRequestFilter filter : filters) {
            client.register((Object)filter);
        }
        WebTarget target = client.target("http://nourl/");
        Response response = target.request().buildGet().invoke();
        return response;
    }
}

