/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.core.linkjaxblink;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Link;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -6053007016837644641L;

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void defaultConstructorTest() throws JAXRSCommonClient.Fault {
        Link.JaxbLink jaxbLink = new Link.JaxbLink();
        boolean getUri = jaxbLink.getUri() == null || jaxbLink.getUri().toASCIIString() == null || jaxbLink.getUri().toASCIIString().isEmpty();
        Assertions.assertTrue((boolean)getUri, (String)("JaxbLink.getUri() is unexpectedly preset to " + jaxbLink.getUri()));
        JAXRSClientIT.logMsg("Link.JaxbLink.getUri() is empty as expected");
        boolean params = jaxbLink.getParams() == null || jaxbLink.getParams().isEmpty();
        Assertions.assertTrue((boolean)params, (String)("JaxbLink.getParams() is unexpectedly preset to " + jaxbLink.getParams()));
        JAXRSClientIT.logMsg("Link.JaxbLink.getParams() is empty as expected");
    }

    @Test
    public void uriConstructorTest() throws JAXRSCommonClient.Fault {
        String uri = "protocol://domain2.domain1:port";
        URI fromString = JAXRSClientIT.uriFromString(uri);
        Link.JaxbLink jaxbLink = new Link.JaxbLink(fromString);
        boolean getUri = jaxbLink.getUri().equals(fromString);
        Assertions.assertTrue((boolean)getUri, (String)("JaxbLink.getUri() is unexpectedly preset to " + jaxbLink.getUri()));
        JAXRSClientIT.logMsg("Link.JaxbLink.getUri() is", uri, "as expected");
        boolean params = jaxbLink.getParams() == null || jaxbLink.getParams().isEmpty();
        Assertions.assertTrue((boolean)params, (String)("JaxbLink.getParams() is unexpectedly preset to " + jaxbLink.getParams()));
        JAXRSClientIT.logMsg("Link.JaxbLink.getParams() is empty as expected");
    }

    @Test
    public void uriParamsConstructorTest() throws JAXRSCommonClient.Fault {
        String uri = "protocol://domain2.domain1:port";
        String q = "qName";
        QName qName = new QName(q);
        URI fromString = JAXRSClientIT.uriFromString(uri);
        HashMap<QName, String> map = new HashMap<QName, String>();
        map.put(qName, q);
        Link.JaxbLink jaxbLink = new Link.JaxbLink(fromString, map);
        boolean getUri = jaxbLink.getUri().equals(fromString);
        Assertions.assertTrue((boolean)getUri, (String)("JaxbLink.getUri() is unexpectedly preset to " + jaxbLink.getUri()));
        JAXRSClientIT.logMsg("Link.JaxbLink.getUri() is", uri, "as expected");
        boolean params = jaxbLink.getParams().containsKey(qName) && jaxbLink.getParams().get(qName).equals(q);
        Assertions.assertTrue((boolean)params, (String)("JaxbLink.getParams() is unexpectedly set to " + jaxbLink.getParams()));
        JAXRSClientIT.logMsg("Link.JaxbLink.getParams() contains", q, "as expected");
    }

    private static URI uriFromString(String uri) throws JAXRSCommonClient.Fault {
        URI fromString = null;
        try {
            fromString = new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
        return fromString;
    }
}

