/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.runtimetype;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.RuntimeType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = -2994744934835260890L;
    static final String[] names = new String[]{"CLIENT", "SERVER"};

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void valueOfTest() throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEqualsInt(RuntimeType.values().length, 2, "Unexpected number of values of RuntimeType enum");
        RuntimeType type = RuntimeType.valueOf((String)names[0]);
        JAXRSClientIT.assertEquals(RuntimeType.CLIENT, type, "Unexpected RuntimeType", type);
        JAXRSClientIT.logMsg("#valueOf(", names[0], ") equals", type, "as expected");
        type = RuntimeType.valueOf((String)names[1]);
        JAXRSClientIT.assertEquals(RuntimeType.SERVER, type, "Unexpected RuntimeType", type);
        JAXRSClientIT.logMsg("#valueOf(", names[1], ") equals", type, "as expected");
    }

    @Test
    public void valuesTest() throws JAXRSCommonClient.Fault {
        RuntimeType[] types = RuntimeType.values();
        JAXRSClientIT.assertEqualsInt(types.length, 2, "Unexpected number of values of RuntimeType enum");
        String[] dynamicNames = new String[]{types[0].name(), types[1].name()};
        String singleDynamicName = dynamicNames[0] + ", " + dynamicNames[1];
        for (String name : names) {
            JAXRSClientIT.assertContains(singleDynamicName, name, new Object[]{name, "has unexpectedly not found in list", singleDynamicName});
            JAXRSClientIT.logMsg("Found", name, "in valus()", singleDynamicName);
        }
    }
}

