/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder;

import ee.jakarta.tck.ws.rs.ee.rs.core.responsebuilder.AnnotatedClass;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Date;

@Provider
public class DateContainerReaderWriter
implements MessageBodyReader<Date>,
MessageBodyWriter<Date> {
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_CONSUMES = 4;
    public static final int ANNOTATION_PROVIDER = 8;
    public static final int ANNOTATION_UNKNOWN = 128;
    public static final String SPLITTER = " ANNOTATION_VALUE ";

    public long getSize(Date arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        Annotation[] annotations = AnnotatedClass.class.getAnnotations();
        return String.valueOf(Long.MAX_VALUE).length() + SPLITTER.length() + annotations[0].annotationType().getName().length() + annotations[1].annotationType().getName().length();
    }

    public boolean isWriteable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return arg0 == Date.class;
    }

    public void writeTo(Date date, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4, MultivaluedMap<String, Object> arg5, OutputStream stream) throws IOException, WebApplicationException {
        String annotation = this.parseAnnotations(arg3);
        stream.write(DateContainerReaderWriter.dateToString(date).getBytes());
        stream.write(SPLITTER.getBytes());
        stream.write(annotation.getBytes());
    }

    public boolean isReadable(Class<?> arg0, Type arg1, Annotation[] arg2, MediaType arg3) {
        return this.isWriteable(arg0, arg1, arg2, arg3);
    }

    public Date readFrom(Class<Date> arg0, Type arg1, Annotation[] arg2, MediaType arg3, MultivaluedMap<String, String> arg4, InputStream arg5) throws IOException, WebApplicationException {
        InputStreamReader reader = new InputStreamReader(arg5);
        BufferedReader br = new BufferedReader(reader);
        long date = Long.parseLong(br.readLine());
        return new Date(date);
    }

    protected String parseAnnotations(Annotation[] annotations) {
        StringBuilder value = new StringBuilder();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                value.append(annotation.annotationType().getName()).append(", ");
            }
        }
        return value.toString();
    }

    public static final String dateToString(Date date) {
        return String.valueOf(date.getTime());
    }
}

