/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.context.client;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.provider.PrintingErrorHandler;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.context.client.Resource;
import ee.jakarta.tck.ws.rs.spec.context.client.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.context.server.StringBeanEntityProviderWithInjectables;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_context_client_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/context/client/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_context_client_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, PrintingErrorHandler.class, StringBean.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void clientWriterTest() throws JAXRSCommonClient.Fault {
        this.addProvider(StringBeanEntityProviderWithInjectables.class);
        this.setRequestContentEntity(new StringBean("stringbean"));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.invoke();
        this.assertInjection("@Context injection did not work properly:");
    }

    @Test
    public void clientReaderTest() throws JAXRSCommonClient.Fault {
        this.addProvider(StringBeanEntityProviderWithInjectables.class);
        this.setRequestContentEntity("stringbean");
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "echo"));
        this.invoke();
        StringBean content = this.getResponseBody(StringBean.class);
        JAXRSClientIT.assertNotNull(content, "response body is null");
        JAXRSClientIT.logMsg("Injectables are", content.get());
        this.assertInjection(content.get(), "@Context injection did not work properly:");
    }

    private void assertInjection(String body, Object failMessage) throws JAXRSCommonClient.Fault {
        JAXRSClientIT.assertEquals(Character.valueOf('1'), Character.valueOf(body.charAt(6)), failMessage, StringBeanEntityProviderWithInjectables.notInjected(body, 6), "has not been injected");
        JAXRSClientIT.assertEquals(Character.valueOf('1'), Character.valueOf(body.charAt(8)), failMessage, StringBeanEntityProviderWithInjectables.notInjected(body, 8), "has not been injected");
        JAXRSClientIT.logMsg("@Context injected as expected");
    }

    private void assertInjection(Object failMessage) throws JAXRSCommonClient.Fault {
        String body = this.getResponseBody();
        this.assertInjection(body, failMessage);
    }
}

