/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.filter.globalbinding;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.filter.globalbinding.AbstractAddFilter;
import ee.jakarta.tck.ws.rs.spec.filter.globalbinding.AbstractAddInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.globalbinding.AddOneInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.globalbinding.AddTenFilter;
import ee.jakarta.tck.ws.rs.spec.filter.globalbinding.GlobalNameBinding;
import ee.jakarta.tck.ws.rs.spec.filter.globalbinding.Resource;
import ee.jakarta.tck.ws.rs.spec.filter.globalbinding.TSAppConfig;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_filter_globalbinding_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/filter/globalbinding/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_filter_globalbinding_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AbstractAddFilter.class, AbstractAddInterceptor.class, AddOneInterceptor.class, AddTenFilter.class, GlobalNameBinding.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void nameBoundResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "bind"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "12");
        this.invoke();
        JAXRSClientIT.logMsg("Bound as expected");
    }

    @Test
    public void globalBoundResourceTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "nobind"));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "0");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "12");
        this.invoke();
        JAXRSClientIT.logMsg("Bound as expected");
    }
}

