/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.filter.lastvalue;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.ArrayListEntityProvider;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.FirstReaderInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.FirstWriterInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.LinkedListEntityProvider;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.Resource;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.SecondReaderInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.SecondWriterInterceptor;
import ee.jakarta.tck.ws.rs.spec.filter.lastvalue.TSAppConfig;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public static final String plaincontent = JAXRSClientIT.class.getName();

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_filter_lastvalue_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/filter/lastvalue/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_filter_lastvalue_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, ArrayListEntityProvider.class, FirstReaderInterceptor.class, FirstWriterInterceptor.class, LinkedListEntityProvider.class, SecondReaderInterceptor.class, SecondWriterInterceptor.class, JaxrsUtil.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void readerContextOnContainerTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(FirstReaderInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "postlist"));
        this.setRequestContentEntity(plaincontent);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SecondReaderInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SecondReaderInterceptor.class.getAnnotations()[0].annotationType().getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
        JAXRSClientIT.logMsg("Last values set in contexts were used as expected");
    }

    @Test
    public void readerContextOnClientTest() throws JAXRSCommonClient.Fault {
        this.addProvider(FirstReaderInterceptor.class);
        this.addProvider(SecondReaderInterceptor.class);
        this.addProvider(ArrayListEntityProvider.class);
        this.addProvider(LinkedListEntityProvider.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setRequestContentEntity(plaincontent);
        this.invoke();
        Response response = this.getResponse();
        response.getHeaders().add((Object)"FILTER_HEADER", (Object)FirstReaderInterceptor.class.getName());
        List list = (List)response.readEntity(List.class);
        Assertions.assertTrue((boolean)ArrayList.class.isInstance(list), (String)"Entity is not instanceof ArrayList");
        String entity = (String)list.get(0);
        JAXRSClientIT.assertContains(entity, SecondReaderInterceptor.class.getName(), new Object[]{"Second value in reader interceptor is unexpectedly not used"});
        JAXRSClientIT.assertContains(entity, SecondReaderInterceptor.class.getAnnotations()[0].annotationType().getName(), new Object[]{"Second value in reader interceptor is unexpectedly not used"});
        JAXRSClientIT.assertContains(entity, "text/plain", new Object[]{"Second value in reader interceptor is unexpectedly not used"});
        JAXRSClientIT.logMsg("Last values set in contexts were used as expected");
    }

    @Test
    public void writerContextOnContainerTest() throws JAXRSCommonClient.Fault {
        this.addInterceptors(FirstWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "getlist"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SecondWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SecondWriterInterceptor.class.getAnnotations()[0].annotationType().getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
        JAXRSClientIT.logMsg("Last values set in contexts were used as expected");
    }

    @Test
    public void writerContextOnClientTest() throws JAXRSCommonClient.Fault {
        this.addProvider(FirstReaderInterceptor.class);
        this.addProvider(SecondReaderInterceptor.class);
        this.addProvider(ArrayListEntityProvider.class);
        this.addProvider(LinkedListEntityProvider.class);
        ArrayList<String> list = new ArrayList<String>();
        list.add(plaincontent);
        this.setRequestContentEntity(list);
        this.addInterceptors(FirstWriterInterceptor.class);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, "poststring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SecondWriterInterceptor.class.getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, SecondWriterInterceptor.class.getAnnotations()[0].annotationType().getName());
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "text/plain");
        this.invoke();
        JAXRSClientIT.logMsg("Last values set in contexts were used as expected");
    }

    private void addInterceptors(Class<?> clazz) {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, "FILTER_HEADER:" + clazz.getName());
    }
}

