/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.table.columnservice;

import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.internal.table.generator.TableColumnGenerator;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.context.ViewModelService;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.table.model.VTableControl;
import org.eclipse.emf.ecp.view.spi.table.model.VTableDomainModelReference;

public class AddColumnService
implements ViewModelService {
    public void instantiate(ViewModelContext context) {
        VElement viewModel = context.getViewModel();
        if (viewModel instanceof VTableControl) {
            this.addColumnsIfNeeded((VTableControl)viewModel);
            return;
        }
        TreeIterator contents = viewModel.eAllContents();
        while (contents.hasNext()) {
            EObject current = (EObject)contents.next();
            if (!(current instanceof VTableControl)) continue;
            VTableControl tableControl = (VTableControl)current;
            this.addColumnsIfNeeded(tableControl);
        }
    }

    private void addColumnsIfNeeded(VTableControl tableControl) {
        if (tableControl.getDomainModelReference() == null) {
            return;
        }
        if (((VTableDomainModelReference)VTableDomainModelReference.class.cast(tableControl.getDomainModelReference())).getColumnDomainModelReferences().size() < 1) {
            Iterator settings = tableControl.getDomainModelReference().getIterator();
            if (!settings.hasNext()) {
                return;
            }
            EStructuralFeature.Setting firstSetting = (EStructuralFeature.Setting)settings.next();
            EStructuralFeature structuralFeature = firstSetting.getEStructuralFeature();
            EClassifier eType = structuralFeature.getEType();
            if (eType instanceof EClass) {
                EClass clazz = (EClass)eType;
                TableColumnGenerator.generateColumns((EClass)clazz, (VTableControl)tableControl);
            }
        }
    }

    public void dispose() {
    }

    public int getPriority() {
        return -1;
    }
}

