/*
 * Decompiled with CFR 0.152.
 */
package configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FeatureBinding implements Enumerator
{
    UNBOUND(0, "Unbound", "UNBOUND"),
    TRUE(1, "True", "TRUE"),
    FALSE(2, "False", "FALSE");

    public static final int UNBOUND_VALUE = 0;
    public static final int TRUE_VALUE = 1;
    public static final int FALSE_VALUE = 2;
    private static final FeatureBinding[] VALUES_ARRAY;
    public static final List<FeatureBinding> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FeatureBinding[]{UNBOUND, TRUE, FALSE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FeatureBinding get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureBinding result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureBinding getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FeatureBinding result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FeatureBinding get(int value) {
        switch (value) {
            case 0: {
                return UNBOUND;
            }
            case 1: {
                return TRUE;
            }
            case 2: {
                return FALSE;
            }
        }
        return null;
    }

    private FeatureBinding(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static String[] getNames() {
        FeatureBinding[] states = FeatureBinding.values();
        String[] names = new String[states.length];
        int i = states.length - 1;
        while (i >= 0) {
            names[i] = states[i].getName();
            --i;
        }
        return names;
    }
}

