/*******************************************************************************
 * Copyright (c) 2008, 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint;

import org.eclipse.emf.common.notify.Notification;

/**
 * Describes a change to a model element's associated Java element set.
 */
public interface IJavaElementNotification extends Notification {
	
	int REFRESH = EVENT_TYPE_COUNT;

	/**
	 * Model element whose set of Java elements (potentially) changed.
	 * 
	 * @return model element whose Java elements changed
	 */
	Object getElement();
}