/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.jdbc;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.util.eclipse.AbstractPlugin;
import org.eclipse.net4j.util.eclipse.Element;
import org.eclipse.net4j.util.eclipse.ExecutableElement;
import org.eclipse.net4j.util.eclipse.ExtensionParser;
import org.eclipse.net4j.util.eclipse.ListExtensionParser;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCPlugin
extends AbstractPlugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.cdo.jdbc";
    public static final String DRIVERS_EXT_POINT_ID = "drivers";
    private static JDBCPlugin plugin;
    private List<DriverElement> driverElements = new ArrayList<DriverElement>();
    private ExtensionParser driverParser = new DriverParser(this.driverElements);

    public JDBCPlugin() {
        if (plugin == null) {
            plugin = this;
        }
    }

    public static JDBCPlugin getDefault() {
        return plugin;
    }

    public List<DriverElement> getDriverElements() {
        return this.driverElements;
    }

    public DriverElement getDriverElement(String driverName) {
        for (DriverElement driver : this.getDriverElements()) {
            if (!driver.getName().equals(driverName)) continue;
            return driver;
        }
        return null;
    }

    public String getDriverClassName(String driverName) {
        DriverElement driver = this.getDriverElement(driverName);
        return driver == null ? null : driver.getClassName();
    }

    public String getDriverExampleURL(String driverName) {
        DriverElement driver = this.getDriverElement(driverName);
        return driver == null ? "" : driver.getExampleURL();
    }

    public SupportedDialectElement[] getSupportedDialects(String driverName) {
        DriverElement driver = this.getDriverElement(driverName);
        return driver == null ? null : driver.getSupportedDialects();
    }

    protected void doStart() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.emf.cdo.jdbc.drivers");
        this.driverParser.parse(point);
        this.checkLibraries();
    }

    protected void doStop() throws Exception {
        this.driverParser = null;
        this.driverElements = null;
        plugin = null;
    }

    protected void checkLibraries() {
        for (DriverElement element : this.driverElements) {
            LibraryElement[] libraries;
            LibraryElement[] libraryElementArray = libraries = element.getLibraries();
            int n = 0;
            int n2 = libraryElementArray.length;
            while (n < n2) {
                String entryPath;
                URL entry;
                LibraryElement library = libraryElementArray[n];
                String fragmentId = library.getFragmentId();
                Bundle bundle = Platform.getBundle((String)fragmentId);
                if (bundle != null && (entry = bundle.getEntry(entryPath = library.getEntryPath())) == null) {
                    String downloadURL = library.getDownloadURL();
                    this.warn("MISSING JDBC LIBRARY: " + fragmentId + "/" + entryPath + (downloadURL != null ? " (" + downloadURL + ")" : ""));
                }
                ++n;
            }
        }
    }

    public class DriverElement
    extends ExecutableElement {
        private String name;
        private String exampleURL;
        private List<SupportedDialectElement> supportedDialects = new ArrayList<SupportedDialectElement>();
        private List<LibraryElement> libraries = new ArrayList<LibraryElement>();

        public String toString() {
            return "Driver(" + this.name + ", " + this.className + ")";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addSupportedDialect(SupportedDialectElement dialect) {
            this.supportedDialects.add(dialect);
        }

        public SupportedDialectElement[] getSupportedDialects() {
            return this.supportedDialects.toArray(new SupportedDialectElement[this.supportedDialects.size()]);
        }

        public void addLibrary(LibraryElement library) {
            this.libraries.add(library);
        }

        public LibraryElement[] getLibraries() {
            return this.libraries.toArray(new LibraryElement[this.libraries.size()]);
        }

        public String getExampleURL() {
            return this.exampleURL;
        }

        public void setExampleURL(String exampleURL) {
            this.exampleURL = exampleURL;
        }
    }

    public class SupportedDialectElement
    extends Element {
        private String name;

        public String toString() {
            return "SupportedDialect(" + this.name + ")";
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public class LibraryElement
    extends Element {
        private String fragmentId;
        private String entryPath;
        private String downloadURL;

        public String toString() {
            return "LibraryElement(" + this.fragmentId + ", " + this.entryPath + ", " + this.downloadURL + ")";
        }

        public String getFragmentId() {
            return this.fragmentId;
        }

        public void setFragmentId(String fragmentId) {
            this.fragmentId = fragmentId;
        }

        public String getEntryPath() {
            return this.entryPath;
        }

        public void setEntryPath(String name) {
            this.entryPath = name;
        }

        public String getDownloadURL() {
            return this.downloadURL;
        }

        public void setDownloadURL(String downloadURL) {
            this.downloadURL = downloadURL;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DriverParser
    extends ListExtensionParser {
        public DriverParser(List<DriverElement> list) {
            super(list);
            this.addFactory("driver", new Element.Factory(){

                public Element createElementData() {
                    return new DriverElement();
                }
            });
            this.addFactory("driver/supportedDialect", new Element.Factory(){

                public Element createElementData() {
                    return new SupportedDialectElement();
                }
            });
            this.addFactory("driver/library", new Element.Factory(){

                public Element createElementData() {
                    return new LibraryElement();
                }
            });
        }
    }
}

