/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.common;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.xtend.backend.common.EvaluationVetoException;
import org.eclipse.xtend.backend.common.ExecutionContext;
import org.eclipse.xtend.backend.common.ExecutionException;
import org.eclipse.xtend.backend.common.ExecutionListener;
import org.eclipse.xtend.backend.common.SourcePos;
import org.eclipse.xtend.backend.common.StacktraceEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExpressionBase {
    private final SourcePos _sourcePos;
    private final List<ExecutionListener> _listeners = new ArrayList<ExecutionListener>();
    protected final Log _log = LogFactory.getLog(this.getClass());

    public ExpressionBase(SourcePos sourcePos) {
        this._sourcePos = sourcePos;
    }

    public SourcePos getPos() {
        return this._sourcePos;
    }

    public void registerExecutionListener(ExecutionListener l) {
        this._listeners.add(l);
    }

    public List<ExecutionListener> getListeners() {
        return this._listeners;
    }

    private void firePreEvent(ExecutionContext ctx) throws EvaluationVetoException {
        for (ExecutionListener l : ctx.getGlobalExecutionListeners()) {
            l.preExecute(ctx, this);
        }
        for (ExecutionListener l : this._listeners) {
            l.preExecute(ctx, this);
        }
    }

    private void firePostEvent(Object result, ExecutionContext ctx) {
        int i = this._listeners.size() - 1;
        while (i >= 0) {
            this._listeners.get(i).postExecute(result, ctx, this);
            --i;
        }
        i = ctx.getGlobalExecutionListeners().size() - 1;
        while (i >= 0) {
            ctx.getGlobalExecutionListeners().get(i).postExecute(result, ctx, this);
            --i;
        }
    }

    public final Object evaluate(ExecutionContext ctx) {
        try {
            this.firePreEvent(ctx);
            Object result = this.evaluateInternal(ctx);
            this.firePostEvent(result, ctx);
            return result;
        }
        catch (EvaluationVetoException exc) {
            return exc.getSubstitutedExpressionResult();
        }
        catch (ExecutionException exc) {
            exc.addStackTraceElement(new StacktraceEntry(this._sourcePos, ctx));
            throw exc;
        }
        catch (Exception exc) {
            throw new ExecutionException(exc, new StacktraceEntry(this._sourcePos, ctx));
        }
    }

    protected abstract Object evaluateInternal(ExecutionContext var1);
}

