/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.profiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.xtend.profiler.profilermodel.CallGroup;
import org.eclipse.xtend.profiler.profilermodel.Item;
import org.eclipse.xtend.profiler.profilermodel.ModelFactory;
import org.eclipse.xtend.profiler.profilermodel.ProfilingResult;

public class Profiler {
    private TimeProvider timeProvider = new TimeProvider(){

        public long getNanoSeconds() {
            return System.nanoTime();
        }
    };
    private final ProfilingResult profilingResult;
    List<Call> stack = new ArrayList<Call>();
    Map<String, Item> items = new HashMap<String, Item>();

    public TimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    public void setTimeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    public ProfilingResult getProfilingResult() {
        return this.profilingResult;
    }

    public Profiler() {
        this(ModelFactory.eINSTANCE.createProfilingResult());
    }

    public Profiler(ProfilingResult profilingResult) {
        this.profilingResult = profilingResult;
    }

    private Item createItem(String key) {
        Item result = ModelFactory.eINSTANCE.createItem();
        result.setItemName(key);
        this.items.put(key, result);
        this.profilingResult.getItems().add((Object)result);
        return result;
    }

    public Item getItem(String key) {
        Item result = this.items.get(key);
        if (result == null) {
            result = this.createItem(key);
        }
        return result;
    }

    public void beginRoutine(String key) {
        if (key == null) {
            this.beginRoutine();
        } else {
            this.beginRoutine(this.getItem(key));
        }
    }

    private CallGroup getCallGroup(Item caller, Item subroutine) {
        for (CallGroup calls : caller.getSubroutines()) {
            if (!calls.getSubroutine().equals(subroutine)) continue;
            return calls;
        }
        CallGroup result = ModelFactory.eINSTANCE.createCallGroup();
        caller.getSubroutines().add((Object)result);
        result.setSubroutine(subroutine);
        return result;
    }

    private void beginRoutine(Item routine) {
        Call call = new Call(routine);
        CallGroup group = this.findCallGroup(routine);
        this.stack.add(0, call);
        call.startCounting(group);
    }

    private CallGroup findCallGroup(Item routine) {
        Item invoker = this.findLastInvoker();
        CallGroup group = null;
        if (invoker != null) {
            group = this.getCallGroup(invoker, routine);
            group.setCount(group.getCount() + 1);
        }
        return group;
    }

    private void beginRoutine() {
        this.stack.add(0, new Call(null));
    }

    private Item findLastInvoker() {
        for (Call call : this.stack) {
            if (call.item == null) continue;
            return call.item;
        }
        return null;
    }

    public void endRoutine() {
        Call lastCall = this.stack.remove(0);
        lastCall.freeze(true);
    }

    public boolean hasFinished() {
        return this.stack.isEmpty();
    }

    class Call {
        final Item item;
        CallGroup callGroup;
        long startedAt;

        Call(Item item) {
            this.item = item;
        }

        void startCounting(CallGroup callGroup) {
            this.startedAt = Profiler.this.timeProvider.getNanoSeconds();
            this.callGroup = callGroup;
        }

        void freeze(boolean measureTimeForItem) {
            long neededTime = Profiler.this.timeProvider.getNanoSeconds() - this.startedAt;
            if (this.item != null && measureTimeForItem) {
                this.item.setItemTime(this.item.getItemTime() + neededTime);
            }
            if (this.callGroup != null) {
                this.callGroup.setTime(this.callGroup.getTime() + neededTime);
            }
        }

        public boolean isSameName(String name) {
            return this.item != null && name.equals(this.item.getName());
        }
    }

    public static interface TimeProvider {
        public long getNanoSeconds();
    }
}

