/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.parsers.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.linuxtools.changelog.core.IParserChangeLogContrib;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class JavaParser
implements IParserChangeLogContrib {
    public static final String STATIC_INITIALIZER_NAME = "static initializer";

    public String parseCurrentFunction(IEditorInput input, int offset) throws CoreException {
        IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
        manager.connect(input);
        ICompilationUnitDocumentProvider x = (ICompilationUnitDocumentProvider)JavaUI.getDocumentProvider();
        ICompilationUnit workingCopy = x.getWorkingCopy((Object)input);
        if (workingCopy == null) {
            return "";
        }
        IJavaElement method = workingCopy.getElementAt(offset);
        manager.disconnect(input);
        if (method == null) {
            return "";
        }
        String currentElementName = method.getElementName();
        if (currentElementName == null) {
            return "";
        }
        int elementType = method.getElementType();
        switch (elementType) {
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                return "";
            }
            case 10: {
                return STATIC_INITIALIZER_NAME;
            }
            default: {
                IJavaElement tmpMethodType = method.getAncestor(9);
                if (tmpMethodType == null && (tmpMethodType = method.getAncestor(7)) == null) {
                    return "";
                }
                method = tmpMethodType;
                currentElementName = method.getElementName();
            }
        }
        IJavaElement tmpParent = method.getParent();
        boolean firstLoop = true;
        while (tmpParent != null) {
            String tmpParentClassName;
            IJavaElement tmpParentClass = tmpParent.getAncestor(7);
            if (tmpParentClass != null) {
                tmpParentClassName = tmpParentClass.getElementName();
                if (tmpParentClassName == null) {
                    return "";
                }
            } else {
                int rootClassPos = currentElementName.indexOf(".");
                if (rootClassPos >= 0) {
                    currentElementName = currentElementName.substring(rootClassPos + 1);
                }
                if (firstLoop) {
                    return "";
                }
                return currentElementName;
            }
            currentElementName = String.valueOf(tmpParentClassName) + "." + currentElementName;
            tmpParent = tmpParentClass.getParent();
            firstLoop = false;
        }
        return "";
    }

    public String parseCurrentFunction(IEditorPart editor) throws CoreException {
        if (!(editor instanceof AbstractDecoratedTextEditor)) {
            return "";
        }
        AbstractDecoratedTextEditor java_editor = (AbstractDecoratedTextEditor)editor;
        ITextSelection selection = (ITextSelection)java_editor.getSelectionProvider().getSelection();
        IEditorInput input = java_editor.getEditorInput();
        return this.parseCurrentFunction(input, selection.getOffset());
    }
}

