/*
 * Decompiled with CFR 0.152.
 */
package com.dtolabs.rundeck.core.authorization.providers;

import com.dtolabs.rundeck.core.authorization.Attribute;
import com.dtolabs.rundeck.core.authorization.Validation;
import com.dtolabs.rundeck.core.authorization.ValidationSet;
import com.dtolabs.rundeck.core.authorization.providers.CacheableYamlSource;
import com.dtolabs.rundeck.core.authorization.providers.PoliciesCache;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollection;
import com.dtolabs.rundeck.core.authorization.providers.PolicyCollectionFactory;
import com.dtolabs.rundeck.core.authorization.providers.SourceProvider;
import com.dtolabs.rundeck.core.authorization.providers.YamlParsePolicy;
import com.dtolabs.rundeck.core.authorization.providers.YamlPolicyFactoryV2;
import com.dtolabs.rundeck.core.authorization.providers.YamlSource;
import com.dtolabs.rundeck.core.authorization.providers.yaml.model.ACLPolicyDoc;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;

public class YamlProvider {
    private static PolicyCollectionFactory factory;
    public static final Class<?> DEFAULT_FACTORY;
    public static final String FACTORY_CLASS_PROPERTY;
    public static final FilenameFilter filenameFilter;

    public static Validation validate(CacheableYamlSource source2, ValidationSet validation) {
        return YamlProvider.validate(source2, null, validation);
    }

    public static Validation validate(CacheableYamlSource source2, Set<Attribute> forcedContext, ValidationSet validation) {
        return YamlProvider.validate(Collections.singletonList(source2), forcedContext, validation);
    }

    public static Validation validate(Iterable<CacheableYamlSource> sources, Set<Attribute> forcedContext, ValidationSet validation) {
        return YamlProvider.validate(validation, sources, forcedContext);
    }

    public static Validation validate(Iterable<CacheableYamlSource> sources, ValidationSet validation) {
        return YamlProvider.validate(sources, null, validation);
    }

    private static Validation validate(ValidationSet validation, Iterable<CacheableYamlSource> sources, Set<Attribute> forcedContext) {
        return YamlProvider.getFactory().validate(validation, sources, forcedContext);
    }

    public static PolicyCollectionFactory getFactory() {
        return factory;
    }

    public static void setFactory(PolicyCollectionFactory factory2) {
        factory = factory2;
    }

    public static PolicyCollection policiesFromSource(YamlSource source2) throws IOException {
        return YamlProvider.policiesFromSource(source2, null, null);
    }

    public static PolicyCollection policiesFromSource(YamlSource source2, Set<Attribute> forcedContext, ValidationSet validation) throws IOException {
        return factory.policiesFromSource(source2, forcedContext, validation);
    }

    public static PolicyCollection policiesFromSource(YamlSource source2, Set<Attribute> forcedContext) throws IOException {
        return YamlProvider.policiesFromSource(source2, forcedContext, null);
    }

    public static PolicyCollection policiesFromFile(File source2) throws IOException {
        return YamlProvider.policiesFromSource(YamlProvider.sourceFromFile(source2, null));
    }

    public static CacheableYamlSource sourceFromFile(File file, ValidationSet validationSet) {
        return new CacheableYamlFileSource(file, validationSet);
    }

    public static Iterable<CacheableYamlSource> asSources(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir should be a directory");
        }
        return YamlProvider.asSources(dir.listFiles(filenameFilter));
    }

    public static Iterable<CacheableYamlSource> asSources(File[] files) {
        ArrayList<CacheableYamlSource> list = new ArrayList<CacheableYamlSource>();
        if (null != files) {
            for (File file : files) {
                list.add(YamlProvider.sourceFromFile(file, null));
            }
        }
        return list;
    }

    public static CacheableYamlSource sourceFromString(final String identity, final String content, final Date modified, final ValidationSet validation) {
        return new CacheableYamlSource(){

            @Override
            public boolean isValid() {
                return true;
            }

            @Override
            public Date getLastModified() {
                return modified;
            }

            @Override
            public String getIdentity() {
                return identity;
            }

            @Override
            public Iterable<ACLPolicyDoc> loadAll(Yaml yaml) throws IOException {
                return YamlParsePolicy.documentIterable(yaml.loadAll(content).iterator(), validation, identity);
            }

            @Override
            public ValidationSet getValidationSet() {
                return validation;
            }

            @Override
            public void close() throws IOException {
            }
        };
    }

    public static CacheableYamlSource sourceFromStream(String identity, InputStream stream, Date modified, ValidationSet validationSet) {
        return new CacheableYamlStreamSource(stream, identity, modified, validationSet);
    }

    public static SourceProvider getDirProvider(File rootDir) {
        return new DirProvider(rootDir);
    }

    public static SourceProvider getFileProvider(File singleFile) {
        return new FileProvider(singleFile);
    }

    static {
        DEFAULT_FACTORY = YamlPolicyFactoryV2.class;
        FACTORY_CLASS_PROPERTY = YamlProvider.class.getName() + ".factoryClass";
        String prop = System.getProperty(FACTORY_CLASS_PROPERTY);
        Class<?> factoryClass = DEFAULT_FACTORY;
        if (null != prop) {
            try {
                factoryClass = Class.forName(prop);
                if (!PolicyCollectionFactory.class.isAssignableFrom(factoryClass)) {
                    throw new RuntimeException("Cannot use class " + prop + " as PolicyCollectionFactory");
                }
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Constructor<?> declaredConstructor = factoryClass.getDeclaredConstructor(new Class[0]);
            Object o = declaredConstructor.newInstance(new Object[0]);
            factory = (PolicyCollectionFactory)o;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".aclpolicy");
            }
        };
    }

    static class FileProvider
    implements SourceProvider {
        private File file;

        public FileProvider(File file) {
            this.file = file;
        }

        @Override
        public Iterator<CacheableYamlSource> getSourceIterator() {
            return YamlProvider.asSources(new File[]{this.file}).iterator();
        }
    }

    static class DirProvider
    implements SourceProvider {
        private File rootDir;
        long lastDirListCheckTime = 0L;
        private File[] lastDirList;

        public DirProvider(File rootDir) {
            this.rootDir = rootDir;
        }

        private File[] listDirFiles() {
            if (System.currentTimeMillis() - this.lastDirListCheckTime > PoliciesCache.DIR_LIST_CHECK_DELAY) {
                this.doListDir();
            }
            return this.lastDirList;
        }

        private void doListDir() {
            this.lastDirList = this.rootDir.listFiles(filenameFilter);
            this.lastDirListCheckTime = System.currentTimeMillis();
        }

        @Override
        public Iterator<CacheableYamlSource> getSourceIterator() {
            return YamlProvider.asSources(this.listDirFiles()).iterator();
        }
    }

    private static class CacheableYamlStreamSource
    implements CacheableYamlSource {
        private final InputStream stream;
        private final String identity;
        private final Date modified;
        private final ValidationSet validationSet;

        public CacheableYamlStreamSource(InputStream stream, String identity, Date modified, ValidationSet validationSet) {
            this.stream = stream;
            this.identity = identity;
            this.modified = modified;
            this.validationSet = validationSet;
        }

        @Override
        public Iterable<ACLPolicyDoc> loadAll(Yaml yaml) throws IOException {
            return YamlParsePolicy.documentIterable(yaml.loadAll(this.stream).iterator(), this.validationSet, this.identity);
        }

        @Override
        public String getIdentity() {
            return this.identity;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public boolean isValid() {
            try {
                return null != this.stream && this.stream.available() > -1;
            }
            catch (IOException e) {
                return false;
            }
        }

        @Override
        public Date getLastModified() {
            return this.modified;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheableYamlStreamSource that = (CacheableYamlStreamSource)o;
            return this.identity.equals(that.identity);
        }

        public int hashCode() {
            return this.identity.hashCode();
        }

        @Override
        public ValidationSet getValidationSet() {
            return this.validationSet;
        }
    }

    private static class CacheableYamlFileSource
    implements CacheableYamlSource {
        private final File file;
        FileInputStream fileInputStream;
        private final ValidationSet validationSet;

        public CacheableYamlFileSource(File file, ValidationSet validationSet) {
            this.file = file;
            this.validationSet = validationSet;
        }

        @Override
        public Iterable<ACLPolicyDoc> loadAll(Yaml yaml) throws IOException {
            if (null == this.fileInputStream) {
                this.fileInputStream = new FileInputStream(this.file);
            }
            return YamlParsePolicy.documentIterable(yaml.loadAll(this.fileInputStream).iterator(), this.validationSet, this.file.getName());
        }

        @Override
        public String getIdentity() {
            return this.file.getAbsolutePath();
        }

        @Override
        public void close() throws IOException {
            if (null != this.fileInputStream) {
                this.fileInputStream.close();
            }
        }

        @Override
        public boolean isValid() {
            return this.file.exists();
        }

        @Override
        public Date getLastModified() {
            return new Date(this.file.lastModified());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheableYamlFileSource that = (CacheableYamlFileSource)o;
            return this.file.equals(that.file);
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        @Override
        public ValidationSet getValidationSet() {
            return this.validationSet;
        }
    }
}

