/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.RoleList;
import org.rundeck.client.api.model.User;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.LoginNameOption;
import org.rundeck.client.tool.options.OutputFormat;
import org.rundeck.client.tool.options.UserFormatOption;
import org.rundeck.client.util.Format;
import picocli.CommandLine;

@CommandLine.Command(description={"Manage user information."}, name="users")
public class Users
extends BaseCommand {
    @CommandLine.Command(description={"Get information of the same user or from another if 'user' is specified."})
    public void info(@CommandLine.Mixin LoginNameOption nameOption, @CommandLine.Mixin UserFormatOption opts) throws IOException, InputError {
        this.getRdTool().requireApiVersion("users info", 21);
        User user = (User)this.apiCall(api -> {
            if (nameOption.isLogin()) {
                return api.getUserInfo(nameOption.getLogin());
            }
            return api.getUserInfo();
        });
        this.outputUserInfo(user, opts);
    }

    private void outputUserInfo(User user, OutputFormat format) {
        CommandOutput output = this.getRdOutput();
        if (format.isVerbose()) {
            output.output(user.toMap());
            return;
        }
        output.info("User profile:");
        if (format.isOutputFormat()) {
            Function<User, String> outformat = Format.formatter(format.getOutputFormat(), User::toMap, "%", "");
            output.output(outformat.apply(user));
        } else {
            output.output(String.format("Login: [%s]", user.getLogin()));
            if (user.hasFirstName()) {
                output.output(String.format("First Name: [%s]", user.getFirstName()));
            }
            if (user.hasLastName()) {
                output.output(String.format("Last Name: [%s]", user.getLastName()));
            }
            if (user.hasEmail()) {
                output.output(String.format("Email: [%s]", user.getEmail()));
            }
        }
    }

    @CommandLine.Command(description={"Edit information of the same user or another if 'user' is specified."})
    public void edit(@CommandLine.Mixin Edit opts, @CommandLine.Mixin UserFormatOption formatOption) throws IOException, InputError {
        this.getRdTool().requireApiVersion("users edit", 21);
        User u = new User();
        if (opts.isEmail()) {
            u.setEmail(opts.getEmail());
        }
        if (opts.isFirstName()) {
            u.setFirstName(opts.getFirstName());
        }
        if (opts.isLastName()) {
            u.setLastName(opts.getLastName());
        }
        User user = (User)this.apiCall(api -> {
            if (opts.isLogin()) {
                return api.editUserInfo(opts.getLogin(), u);
            }
            return api.editUserInfo(u);
        });
        this.outputUserInfo(user, formatOption);
    }

    @CommandLine.Command(description={"Get the list of users."})
    public void list(@CommandLine.Mixin UserFormatOption formatOption) throws IOException, InputError {
        this.getRdTool().requireApiVersion("users list", 21);
        List users = (List)this.apiCall(RundeckApi::listUsers);
        if (formatOption.isVerbose()) {
            this.getRdOutput().output(users.stream().map(User::toMap).collect(Collectors.toList()));
            return;
        }
        Function<User, Object> outformat = formatOption.isOutputFormat() ? Format.formatter(formatOption.getOutputFormat(), User::toMap, "%", "") : User::toBasicString;
        this.getRdOutput().info(String.format("%d Users:", users.size()));
        users.forEach(e -> this.getRdOutput().output(outformat.apply((User)e)));
    }

    @CommandLine.Command(description={"Get the list of roles for the current user."})
    public void roles() throws IOException, InputError {
        this.getRdTool().requireApiVersion("user roles", 30);
        RoleList roleList = (RoleList)this.apiCall(RundeckApi::listRoles);
        this.getRdOutput().info(String.format("%d Roles:", roleList.getRoles().size()));
        roleList.getRoles().forEach(e -> this.getRdOutput().output(e));
    }

    static class Edit
    extends LoginNameOption {
        @CommandLine.Option(names={"-e", "--email"}, description={"user email"})
        private String email;
        @CommandLine.Option(names={"-n", "--name"}, description={"user first name"})
        private String firstName;
        @CommandLine.Option(names={"-l", "--last"}, description={"user last name"})
        String lastName;

        Edit() {
        }

        boolean isEmail() {
            return this.email != null;
        }

        boolean isFirstName() {
            return this.firstName != null;
        }

        boolean isLastName() {
            return this.lastName != null;
        }

        public String getEmail() {
            return this.email;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public void setLastName(String lastName) {
            this.lastName = lastName;
        }
    }
}

