/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.repository;

import java.io.IOException;
import java.util.concurrent.Callable;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.repository.RepositoryResponseHandler;
import org.rundeck.client.tool.extension.RdCommandExtension;
import org.rundeck.client.tool.extension.RdOutput;
import org.rundeck.client.tool.extension.RdTool;
import picocli.CommandLine;

@CommandLine.Command(description={"Unistall a Rundeck plugin from your Rundeck instance"}, name="uninstall")
public class UninstallPlugin
implements Callable<Integer>,
RdCommandExtension,
RdOutput {
    private RdTool rdTool;
    private CommandOutput rdOutput;
    @CommandLine.Option(names={"--id", "-i"}, description={"Id of the plugin you want to uninstall"}, required=true)
    String pluginId;

    @Override
    public Integer call() throws InputError, IOException {
        RepositoryResponseHandler.handle(this.rdTool.apiWithErrorResponse(api -> api.uninstallPlugin(this.pluginId)), this.rdOutput);
        return 0;
    }

    @Override
    public void setRdTool(RdTool rdTool) {
        this.rdTool = rdTool;
    }

    @Override
    public void setRdOutput(CommandOutput rdOutput) {
        this.rdOutput = rdOutput;
    }
}

