/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.repository;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import okhttp3.RequestBody;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.commands.repository.RepositoryResponseHandler;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.util.Client;
import picocli.CommandLine;

@CommandLine.Command(description={"Upload a Rundeck plugin to your plugin repository"}, name="upload")
public class UploadPlugin
extends BaseCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-r", "--repository"}, description={"Target name of repository to upload plugin into."}, required=true)
    String repoName;
    @CommandLine.Option(names={"-f", "--file"}, description={"Path to Rundeck 2.0 plugin to install in your repository"}, required=true)
    String binaryPath;

    @Override
    public Integer call() throws InputError, IOException {
        File binary = new File(this.binaryPath);
        if (!binary.exists()) {
            throw new IOException(String.format("Unable to find specified file: %s", this.binaryPath));
        }
        RequestBody fileUpload = RequestBody.create(binary, Client.MEDIA_TYPE_OCTET_STREAM);
        RepositoryResponseHandler.handle(this.getRdTool().apiWithErrorResponse(api -> api.uploadPlugin(this.repoName, fileUpload)), this.getRdOutput());
        return 0;
    }
}

