/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.options;

import java.util.regex.Pattern;
import org.rundeck.client.tool.ProjectInput;
import picocli.CommandLine;

public class ProjectRequiredNameOptions
implements ProjectInput {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;
    @CommandLine.Option(names={"-p", "--project"}, description={"Project name"}, required=true)
    private String project;

    void validate() {
        ProjectRequiredNameOptions.validateProjectName(this.getProject(), this.spec);
    }

    public static void validateProjectName(String project, CommandLine.Model.CommandSpec spec) {
        Pattern pat = Pattern.compile("^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$");
        if (!pat.matcher(project).matches()) {
            throw new CommandLine.ParameterException(spec.commandLine(), "Invalid option: --project/-p does not match: ^[-_a-zA-Z0-9+][-\\._a-zA-Z0-9+]*$");
        }
    }

    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @Override
    public String getProject() {
        return this.project;
    }

    public void setSpec(CommandLine.Model.CommandSpec spec) {
        this.spec = spec;
    }

    public void setProject(String project) {
        this.project = project;
    }
}

