/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.BatikRasterizer;
import guru.nidi.graphviz.engine.BuiltInRasterizer;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizLoader;
import guru.nidi.graphviz.engine.NopRasterizer;
import guru.nidi.graphviz.engine.SalamanderRasterizer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.function.Consumer;
import org.slf4j.LoggerFactory;

public interface Rasterizer {
    public static final Rasterizer NONE = new NopRasterizer();
    public static final Rasterizer BATIK = GraphvizLoader.isOnClasspath("org/apache/batik/transcoder/Transcoder.class") ? new BatikRasterizer() : NONE;
    public static final Rasterizer SALAMANDER = GraphvizLoader.isOnClasspath("com/kitfox/svg/SVGDiagram.class") ? new SalamanderRasterizer() : NONE;
    public static final Rasterizer DEFAULT = Rasterizer.getDefault();

    public static Rasterizer getDefault() {
        Rasterizer r;
        Rasterizer rasterizer = r = BATIK != NONE ? BATIK : SALAMANDER;
        if (r == NONE) {
            LoggerFactory.getLogger(Rasterizer.class).warn("Neither Batik nor Salamander found on classpath");
        }
        return r;
    }

    public static Rasterizer builtIn(String format) {
        return new BuiltInRasterizer(format, null, null);
    }

    public static Rasterizer builtIn(String format, String renderer) {
        return new BuiltInRasterizer(format, renderer, null);
    }

    public static Rasterizer builtIn(String format, String renderer, String formatter) {
        return new BuiltInRasterizer(format, renderer, formatter);
    }

    public Format format();

    public BufferedImage rasterize(Graphviz var1, Consumer<Graphics2D> var2, String var3);
}

