/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.jar;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.inject.Named;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.io.output.NullPrintStream;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.ModularJarArchiver;
import org.codehaus.plexus.archiver.zip.ConcurrentJarCreator;
import org.codehaus.plexus.util.IOUtil;

@Named(value="mjar")
public class JarToolModularJarArchiver
extends ModularJarArchiver {
    private static final String MODULE_DESCRIPTOR_FILE_NAME = "module-info.class";
    private static final Pattern MRJAR_VERSION_AREA = Pattern.compile("META-INF/versions/\\d+/");
    private Object jarTool;
    private boolean moduleDescriptorFound;
    private boolean hasJarDateOption;

    public JarToolModularJarArchiver() {
        try {
            Class<?> toolProviderClass = Class.forName("java.util.spi.ToolProvider");
            Object jarToolOptional = toolProviderClass.getMethod("findFirst", String.class).invoke(null, "jar");
            this.jarTool = jarToolOptional.getClass().getMethod("get", new Class[0]).invoke(jarToolOptional, new Object[0]);
        }
        catch (ReflectiveOperationException | SecurityException exception) {
            // empty catch block
        }
    }

    @Override
    protected void zipFile(InputStreamSupplier is, ConcurrentJarCreator zOut, String vPath, long lastModified, File fromArchive, int mode, String symlinkDestination, boolean addInParallel) throws IOException, ArchiverException {
        if (this.jarTool != null && this.isModuleDescriptor(vPath)) {
            this.getLogger().debug("Module descriptor found: " + vPath);
            this.moduleDescriptorFound = true;
        }
        super.zipFile(is, zOut, vPath, lastModified, fromArchive, mode, symlinkDestination, addInParallel);
    }

    @Override
    protected void postCreateArchive() throws ArchiverException {
        if (!this.moduleDescriptorFound) {
            return;
        }
        try {
            Integer result2;
            this.getLogger().debug("Using the jar tool to update the archive to modular JAR.");
            Method jarRun = this.jarTool.getClass().getMethod("run", PrintStream.class, PrintStream.class, String[].class);
            if (this.getLastModifiedTime() != null) {
                this.hasJarDateOption = this.isJarDateOptionSupported(jarRun);
                this.getLogger().debug("jar tool --date option is supported: " + this.hasJarDateOption);
            }
            if ((result2 = (Integer)jarRun.invoke(this.jarTool, System.out, System.err, this.getJarToolArguments())) != null && result2 != 0) {
                throw new ArchiverException("Could not create modular JAR file. The JDK jar tool exited with " + result2);
            }
            if (!this.hasJarDateOption && this.getLastModifiedTime() != null) {
                this.getLogger().debug("Fix last modified time zip entries.");
                this.fixLastModifiedTimeZipEntries();
            }
        }
        catch (IOException | ReflectiveOperationException | SecurityException e) {
            throw new ArchiverException("Exception occurred while creating modular JAR file", e);
        }
    }

    private void fixLastModifiedTimeZipEntries() throws IOException {
        long timeMillis = this.getLastModifiedTime().toMillis();
        Path destFile = this.getDestFile().toPath();
        PosixFileAttributes posixFileAttributes = Files.getFileAttributeView(destFile, PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).readAttributes();
        FileAttribute[] attributes = posixFileAttributes != null ? new FileAttribute[]{PosixFilePermissions.asFileAttribute(posixFileAttributes.permissions())} : new FileAttribute[]{};
        Path tmpZip = Files.createTempFile(destFile.getParent(), null, null, attributes);
        try {
            try (ZipFile zipFile = new ZipFile(this.getDestFile());
                 ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(tmpZip, new OpenOption[0]));){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    entry.setTime(timeMillis);
                    out.putNextEntry(entry);
                    if (!entry.isDirectory()) {
                        IOUtil.copy(zipFile.getInputStream(entry), (OutputStream)out);
                    }
                    out.closeEntry();
                }
            }
            Files.move(tmpZip, destFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            try {
                Files.delete(tmpZip);
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            throw e;
        }
    }

    private boolean isModuleDescriptor(String path) {
        if (path.endsWith(MODULE_DESCRIPTOR_FILE_NAME)) {
            String prefix = path.substring(0, path.lastIndexOf(MODULE_DESCRIPTOR_FILE_NAME));
            return prefix.isEmpty() || MRJAR_VERSION_AREA.matcher(prefix).matches();
        }
        return false;
    }

    private String[] getJarToolArguments() throws IOException {
        String mainClass;
        File tempEmptyDir = Files.createTempDirectory(null, new FileAttribute[0]).toFile();
        tempEmptyDir.deleteOnExit();
        ArrayList<String> args = new ArrayList<String>();
        args.add("--update");
        args.add("--file");
        args.add(this.getDestFile().getAbsolutePath());
        String string = mainClass = this.getModuleMainClass() != null ? this.getModuleMainClass() : this.getManifestMainClass();
        if (mainClass != null) {
            args.add("--main-class");
            args.add(mainClass);
        }
        if (this.getModuleVersion() != null) {
            args.add("--module-version");
            args.add(this.getModuleVersion());
        }
        if (!this.isCompress()) {
            args.add("--no-compress");
        }
        if (this.hasJarDateOption) {
            FileTime localTime = JarToolModularJarArchiver.revertToLocalTime(this.getLastModifiedTime());
            args.add("--date");
            args.add(localTime.toString());
        }
        args.add("-C");
        args.add(tempEmptyDir.getAbsolutePath());
        args.add(".");
        return args.toArray(new String[0]);
    }

    private static FileTime revertToLocalTime(FileTime time) {
        long restoreToLocalTime = time.toMillis();
        Calendar cal = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        cal.setTimeInMillis(restoreToLocalTime);
        return FileTime.fromMillis(restoreToLocalTime += (long)(cal.get(15) + cal.get(16)));
    }

    private boolean isJarDateOptionSupported(Method runMethod) {
        try {
            String[] args = new String[]{"--date", "2099-12-31T23:59:59Z", "--version"};
            NullPrintStream nullPrintStream = NullPrintStream.NULL_PRINT_STREAM;
            Integer result2 = (Integer)runMethod.invoke(this.jarTool, nullPrintStream, nullPrintStream, args);
            return result2 != null && result2 == 0;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            return false;
        }
    }
}

